/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import technology.rocketjump.undermount.entities.SequentialIdGenerator;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.DecorationInventoryComponent;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.components.FurnitureInventoryComponent;
import technology.rocketjump.undermount.entities.model.EntityComponentMap;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.AttachedEntity;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.EquippedItemComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HaulingComponent;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemHoldPosition;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.misc.VectorUtils;

public class Entity {
    private final long id = SequentialIdGenerator.nextId();
    private final EntityType type;
    private final PhysicalEntityComponent physicalEntityComponent;
    private final LocationComponent locationComponent;
    private BehaviourComponent behaviourComponent;
    private final EntityComponentMap componentMap = new EntityComponentMap();
    private List<AttachedEntity> attachedEntities = new ArrayList<AttachedEntity>();
    private static final List<GridPoint2> EMPTY_LIST = new LinkedList<GridPoint2>();

    public Entity(EntityType type, PhysicalEntityComponent physicalEntityComponent, BehaviourComponent behaviourComponent, LocationComponent locationComponent, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.type = type;
        this.physicalEntityComponent = physicalEntityComponent;
        this.locationComponent = locationComponent;
        this.componentMap.add(physicalEntityComponent);
        this.componentMap.add(locationComponent);
        if (areaMap != null && behaviourComponent != null) {
            this.behaviourComponent = behaviourComponent;
            behaviourComponent.init(this, messageDispatcher, areaMap);
            this.componentMap.add(behaviourComponent);
        } else {
            this.behaviourComponent = null;
        }
        locationComponent.init(this);
    }

    public Entity clone(MessageDispatcher messageDispatcher, TiledMap areaMap) {
        Entity cloned = new Entity(this.type, this.physicalEntityComponent.clone(messageDispatcher, areaMap), this.behaviourComponent == null ? null : (BehaviourComponent)this.behaviourComponent.clone(messageDispatcher, areaMap), this.locationComponent.clone(messageDispatcher, areaMap), messageDispatcher, areaMap);
        for (Class componentClass : this.componentMap.keySet()) {
            Object clonedComponent = cloned.componentMap.get(componentClass);
            if (clonedComponent != null) continue;
            Object thisComponent = this.componentMap.get(componentClass);
            cloned.componentMap.add(thisComponent.clone(messageDispatcher, areaMap));
        }
        return cloned;
    }

    public List<AttachedEntity> getAttachedEntities() {
        this.attachedEntities.clear();
        if (this.type.equals((Object)EntityType.HUMANOID)) {
            HaulingComponent haulingComponent = this.getComponent(HaulingComponent.class);
            if (haulingComponent != null && haulingComponent.getHauledItem() != null) {
                Entity hauledItem = haulingComponent.getHauledItem();
                if (hauledItem.getType().equals((Object)EntityType.ITEM)) {
                    ItemEntityAttributes attributes = (ItemEntityAttributes)hauledItem.getPhysicalEntityComponent().getAttributes();
                    this.attachedEntities.add(new AttachedEntity(hauledItem, attributes.getItemType().getHoldPosition()));
                }
            } else {
                Entity equippedItem;
                EquippedItemComponent equippedItemComponent = this.getComponent(EquippedItemComponent.class);
                if (equippedItemComponent != null && (equippedItem = equippedItemComponent.getEquippedItem()) != null) {
                    ItemEntityAttributes attributes = (ItemEntityAttributes)equippedItem.getPhysicalEntityComponent().getAttributes();
                    this.attachedEntities.add(new AttachedEntity(equippedItem, attributes.getItemType().getHoldPosition()));
                }
            }
        } else if (this.type.equals((Object)EntityType.FURNITURE)) {
            FurnitureInventoryComponent furnitureInventoryComponent;
            DecorationInventoryComponent decorationInventoryComponent = this.getComponent(DecorationInventoryComponent.class);
            if (decorationInventoryComponent != null) {
                List<Entity> decorationItems = decorationInventoryComponent.getDecorationItems();
                if (decorationItems.size() >= 1) {
                    this.attachedEntities.add(new AttachedEntity(decorationItems.get(0), ItemHoldPosition.DECORATION_1));
                }
                if (decorationItems.size() >= 2) {
                    this.attachedEntities.add(new AttachedEntity(decorationItems.get(1), ItemHoldPosition.DECORATION_2));
                }
            }
            if ((furnitureInventoryComponent = this.getComponent(FurnitureInventoryComponent.class)) != null) {
                List<Entity> inventoryItems = furnitureInventoryComponent.getInventoryItems();
                if (inventoryItems.size() >= 1) {
                    this.attachedEntities.add(new AttachedEntity(inventoryItems.get(0), ItemHoldPosition.WORKSPACE_1));
                }
                if (inventoryItems.size() >= 2) {
                    this.attachedEntities.add(new AttachedEntity(inventoryItems.get(1), ItemHoldPosition.WORKSPACE_2));
                }
            }
        }
        return this.attachedEntities;
    }

    public void update(float deltaTime, TiledMap areaMap) {
        this.behaviourComponent.update(deltaTime, areaMap);
    }

    public void infrequentUpdate(GameContext gameContext) {
        this.behaviourComponent.infrequentUpdate(gameContext);
    }

    public boolean isUpdateEveryFrame() {
        return this.behaviourComponent.isUpdateEveryFrame();
    }

    public boolean isUpdateInfrequently() {
        return this.behaviourComponent.isUpdateInfrequently();
    }

    public long getId() {
        return this.id;
    }

    public PhysicalEntityComponent getPhysicalEntityComponent() {
        return this.physicalEntityComponent;
    }

    public LocationComponent getLocationComponent() {
        return this.locationComponent;
    }

    public BehaviourComponent getBehaviourComponent() {
        return this.behaviourComponent;
    }

    public void setBehaviourComponent(BehaviourComponent behaviourComponent) {
        this.behaviourComponent = behaviourComponent;
    }

    public EntityType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.id == entity.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean isJobAssignable() {
        return this.behaviourComponent.isJobAssignable();
    }

    public <T extends EntityComponent> T getComponent(Class<T> classType) {
        return this.componentMap.get(classType);
    }

    public <T extends EntityComponent> T getOrCreateComponent(Class<T> classType) {
        Object component = this.componentMap.get(classType);
        if (component == null) {
            try {
                component = (EntityComponent)classType.newInstance();
                this.componentMap.add(component);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return component;
    }

    public void addComponent(EntityComponent component) {
        this.componentMap.add(component);
    }

    public void removeComponent(Class<HaulingComponent> componentClass) {
        this.componentMap.remove(componentClass);
    }

    public List<GridPoint2> calculateOtherTilePositions() {
        if (this.type.equals((Object)EntityType.FURNITURE)) {
            LinkedList<GridPoint2> otherPositions = new LinkedList<GridPoint2>();
            FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)this.physicalEntityComponent.getAttributes();
            GridPoint2 primaryTilePosition = VectorUtils.toGridPoint(this.locationComponent.getWorldPosition());
            for (GridPoint2 extraTileOffset : attributes.getCurrentLayout().getExtraTiles()) {
                otherPositions.add(primaryTilePosition.cpy().add(extraTileOffset));
            }
            return otherPositions;
        }
        return EMPTY_LIST;
    }

    public static class YDepthEntityComparator
    implements Comparator<Entity> {
        @Override
        public int compare(Entity o1, Entity o2) {
            return (int)(100000.0f * (((Entity)o2).locationComponent.getWorldPosition().y - ((Entity)o1).locationComponent.getWorldPosition().y));
        }
    }
}

